<?php $__env->startSection('title'); ?>
    <?php echo e(__('Billing')); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <!-- Page Title-->
    <div class="page-title">
        <div class="container">
            <div class="column">
                <ul class="breadcrumbs">
                    <li><a href="<?php echo e(route('front.index')); ?>"><?php echo e(__('Home')); ?></a> </li>
                    <li class="separator"></li>
                    <li><?php echo e(__('Billing address')); ?></li>
                </ul>
            </div>
        </div>
    </div>

    <!-- Page Content-->
    <div class="container padding-bottom-3x mb-1 checkut-page">
        <div class="row">
            <div class="col-xl-8 col-lg-8">
                <div class="row">
                    <div class="col-12">
                        <section class="card widget widget-featured-posts widget-featured-products p-4">
                            <h3 class="widget-title"><?php echo e(__('Items In Your Cart')); ?></h3>
                            <?php $__currentLoopData = $cart; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="entry">
                                    <div class="entry-thumb"><a href="<?php echo e(route('front.product', $item['slug'])); ?>"><img
                                                src="<?php echo e(url('/core/public/storage/images/' . $item['photo'])); ?>" alt="Product"></a>
                                    </div>
                                    <div class="entry-content">
                                        <h4 class="entry-title"><a href="<?php echo e(route('front.product', $item['slug'])); ?>">
                                                <?php echo e(Str::limit($item['name'], 45)); ?>


                                            </a></h4>
                                        <span class="entry-meta"><?php echo e($item['qty']); ?> x

                                            <?php    
                                                $totalAttributePrice = 0;
                                                foreach ($item['attribute']['option_price'] as $option_price) {
                                                    $totalAttributePrice += $option_price;
                                                }
                                                $price = $item['main_price'] + $totalAttributePrice;
                                            ?>
                                            <?php echo e(PriceHelper::setCurrencyPrice($price)); ?>.</span>

                                            <?php $__currentLoopData = $item['attribute']['option_name']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $optionkey => $option_name): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <div class="entry-meta">
                                                <span class="entry-meta d-inline"><?php echo e($item['attribute']['names'][$optionkey]); ?>:</span>
                                                <span class="entry-meta d-inline"><b><?php echo e($option_name); ?></b></span>
                                            </div>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </div>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </section>
                        <div class="card">
                            <div class="card-body">
                                <h6><?php echo e(__('Billing Address')); ?></h6>
                                <form id="checkoutBilling" action="<?php echo e(route('front.checkout.store')); ?>" method="POST">
                                    <?php echo csrf_field(); ?>
                                    <input type="hidden" name="single_page_checkout" value="1">
                                    <div class="row">
                                        <div class="col-sm-6">
                                            <div class="form-group">
                                                <label for="checkout-fn"><?php echo e(__('First Name')); ?>*</label>
                                                <input class="form-control <?php echo e($errors->has('bill_first_name') ? 'requireInput' : ''); ?>" name="bill_first_name" type="text" 
                                                    id="checkout-fn" value="<?php echo e(isset($user) ? $user->first_name : ''); ?>">
                                            </div>
                                        </div>
                                        <div class="col-sm-6">
                                            <div class="form-group">
                                                <label for="checkout-ln"><?php echo e(__('Last Name')); ?>*</label>
                                                <input class="form-control <?php echo e($errors->has('bill_last_name') ? 'requireInput' : ''); ?>" name="bill_last_name" type="text" 
                                                    id="checkout-ln" value="<?php echo e(isset($user) ? $user->last_name : ''); ?>">
                                            </div>
                                        </div>
                                        <div class="col-sm-6">
                                            <div class="form-group">
                                                <label for="checkout_email_billing"><?php echo e(__('E-mail Address')); ?>*</label>
                                                <input class="form-control <?php echo e($errors->has('bill_email') ? 'requireInput' : ''); ?>" name="bill_email" type="email" 
                                                    id="checkout_email_billing"
                                                    value="<?php echo e(isset($user) ? $user->email : ''); ?>">
                                            </div>
                                        </div>
                                        <div class="col-sm-6">
                                            <div class="form-group">
                                                <label for="checkout-phone"><?php echo e(__('Phone Number')); ?>*</label>
                                                <input class="form-control <?php echo e($errors->has('bill_phone') ? 'requireInput' : ''); ?>" name="bill_phone" type="text"
                                                    id="checkout-phone" 
                                                    value="<?php echo e(isset($user) ? $user->phone : ''); ?>">
                                            </div>
                                        </div>
                                    </div>
                                    <?php if(PriceHelper::CheckDigital()): ?>
                                        <div class="row">
                                            <div class="col-sm-6">
                                                <div class="form-group">
                                                    <label for="checkout-address1"><?php echo e(__('Address')); ?>*</label>
                                                    <input class="form-control <?php echo e($errors->has('bill_address1') ? 'requireInput' : ''); ?>" name="bill_address1" 
                                                        type="text" id="checkout-address1"
                                                        value="<?php echo e(isset($user) ? $user->bill_address1 : ''); ?>">
                                                </div>
                                            </div>
                                            <div class="col-sm-6">
                                                <div class="form-group">
                                                    <label for="checkout-zip"><?php echo e(__('Zip Code')); ?>*</label>
                                                    <input class="form-control <?php echo e($errors->has('bill_zip') ? 'requireInput' : ''); ?>" name="bill_zip" type="text"
                                                        id="checkout-zip"
                                                        value="<?php echo e(isset($user) ? $user->bill_zip : ''); ?>">
                                                </div>
                                            </div>
                                            <div class="col-sm-6">
                                                <div class="form-group">
                                                    <label for="checkout-city"><?php echo e(__('City')); ?>*</label>
                                                    <input class="form-control <?php echo e($errors->has('bill_city') ? 'requireInput' : ''); ?>" name="bill_city" type="text" 
                                                        id="checkout-city"
                                                        value="<?php echo e(isset($user) ? $user->bill_city : ''); ?>">
                                                </div>
                                            </div>
                                            <div class="col-sm-6">
                                                <div class="form-group">
                                                    <label for="checkout-country"><?php echo e(__('Country')); ?></label>
                                                    <select class="form-control"  name="bill_country"
                                                        id="billing-country">
                                                        <option selected><?php echo e(__('Choose Country')); ?></option>
                                                        <?php $__currentLoopData = DB::table('countries')->get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $country): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                            <option value="<?php echo e($country->name); ?>"
                                                                <?php echo e(isset($user) && $user->bill_country == $country->name ? 'selected' : ''); ?>>
                                                                <?php echo e($country->name); ?></option>
                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                    </select>
                                                </div>
                                            </div>
                                        </div>
                                    <?php endif; ?>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <!-- Sidebar          -->
            <div class="col-xl-4 col-lg-4">
                <?php echo $__env->make('includes.single_checkout_sidebar', $cart, \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                <?php echo $__env->make('includes.single_checkout_modal', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('master.front', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/nirjhor/domains/app.nirjhor.net/public_html/ecommerce/core/resources/views/front/checkout/index.blade.php ENDPATH**/ ?>