<aside class="sidebar">
    <div class="padding-top-2x hidden-lg-up"></div>
    <!-- Items in Cart Widget-->

    <section class="card widget widget-featured-posts widget-order-summary p-4">
        <h3 class="widget-title"><?php echo e(__('Order Summary')); ?></h3>
        <?php
            $free_shipping = DB::table('shipping_services')->whereStatus(1)->whereIsCondition(1)->first();
        ?>

        <?php if($free_shipping): ?>
            <?php if($free_shipping->minimum_price >= $cart_total): ?>
                <p class="free-shippin-aa"><em><?php echo e(__('Free Shipping After Order')); ?>

                        <?php echo e(PriceHelper::setCurrencyPrice($free_shipping->minimum_price)); ?></em></p>
            <?php endif; ?>
        <?php endif; ?>

        <table class="table">
            <tr>
                <td><?php echo e(__('Cart subtotal')); ?>:</td>
                <td class="text-gray-dark"><?php echo e(PriceHelper::setCurrencyPrice($cart_total)); ?></td>
            </tr>

            <?php if($tax != 0): ?>
                <tr>
                    <td><?php echo e(__('Estimated tax')); ?>:</td>
                    <td class="text-gray-dark"><?php echo e(PriceHelper::setCurrencyPrice($tax)); ?></td>
                </tr>
            <?php endif; ?>

            <?php if(DB::table('states')->count() > 0): ?>
                <tr class="<?php echo e(Auth::check() && Auth::user()->state_id ? '' : 'd-none'); ?> set__state_price_tr">
                    <td><?php echo e(__('State tax')); ?>:</td>
                    <td class="text-gray-dark set__state_price">
                        <?php echo e(PriceHelper::setCurrencyPrice(Auth::check() && Auth::user()->state_id ? ($cart_total * Auth::user()->state->price) / 100 : 0)); ?>

                    </td>
                </tr>
            <?php endif; ?>

            <?php if($discount): ?>
                <tr>
                    <td><?php echo e(__('Coupon discount')); ?>:</td>
                    <td class="text-danger">-
                        <?php echo e(PriceHelper::setCurrencyPrice($discount ? $discount['discount'] : 0)); ?></td>
                </tr>
            <?php endif; ?>

            <?php if($shipping): ?>
                <tr class="d-none set__shipping_price_tr">
                    <td><?php echo e(__('Shipping')); ?>:</td>
                    <td class="text-gray-dark set__shipping_price">
                        <?php echo e(PriceHelper::setCurrencyPrice($shipping ? $shipping->price : 0)); ?></td>
                </tr>
            <?php endif; ?>
            <tr>
                <td class="text-lg text-primary"><?php echo e(__('Order total')); ?></td>
                <td class="text-lg text-primary grand_total_set"><?php echo e(PriceHelper::setCurrencyPrice($grand_total)); ?>

                </td>
            </tr>
        </table>
    </section>

    <?php if(PriceHelper::CheckDigital() == true): ?>
    <section class="card widget widget-featured-posts widget-order-summary p-4">
        <h3 class="widget-title"><?php echo e(__('Shipping Options')); ?></h3>
        <div class="row">
            <div class="col-sm-12 mb-3">
                <?php if(PriceHelper::CheckDigital() == true): ?>
                    <?php
                        $free_shipping = DB::table('shipping_services')->whereStatus(1)->whereIsCondition(1)->first();
                    ?>

                    <select name="shipping_id" class="form-control" id="shipping_id_select" required>
                        <option value="" selected disabled><?php echo e(__('Select Shipping Method')); ?>*</option>
                        <?php $__currentLoopData = DB::table('shipping_services')->whereStatus(1)->get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $shipping): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <?php if($shipping->id == 1 && isset($free_shipping) && $free_shipping->minimum_price <= $cart_total): ?>
                                <option value="<?php echo e($shipping->id); ?>" data-href="<?php echo e(route('front.shipping.setup')); ?>">
                                    <?php echo e($shipping->title); ?>

                                </option>
                            <?php else: ?>
                                <?php if($shipping->id != 1): ?>
                                    <option value="<?php echo e($shipping->id); ?>"
                                        data-href="<?php echo e(route('front.shipping.setup')); ?>"><?php echo e($shipping->title); ?>

                                        (<?php echo e(PriceHelper::setCurrencyPrice($shipping->price)); ?>)
                                    </option>
                                <?php endif; ?>
                            <?php endif; ?>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                    <?php $__errorArgs = ['shipping_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <p class="text-danger shipping_message"><?php echo e($message); ?></p>
                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>

                <?php endif; ?>
            </div>
            <div class="col-sm-12 mb-3">
                <?php if(PriceHelper::CheckDigital() == true): ?>
                    <?php if(DB::table('states')->whereStatus(1)->count() > 0): ?>
                        <select name="state_id" class="form-control" id="state_id_select" required>
                            <option value="" selected disabled><?php echo e(__('Select Shipping State')); ?>*</option>
                            <?php $__currentLoopData = DB::table('states')->whereStatus(1)->get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $state): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($state->id); ?>" data-href="<?php echo e(route('front.state.setup')); ?>"
                                    <?php echo e(Auth::check() && Auth::user()->state_id == $state->id ? 'selected' : ''); ?>>
                                    <?php echo e($state->name); ?>

                                    <?php if($state->type == 'fixed'): ?>
                                        (<?php echo e(PriceHelper::setCurrencyPrice($state->price)); ?>)
                                    <?php else: ?>
                                        (<?php echo e($state->price); ?>%)
                                    <?php endif; ?>

                                </option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                        <?php $__errorArgs = ['state_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <p class="text-danger state_message"><?php echo e($message); ?></p>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    <?php endif; ?>
                <?php endif; ?>
            </div>
        </div>

    </section>
    <?php endif; ?>



    <!-- Order Summary Widget-->
    <section class="card widget  widget-order-summary p-4 mb-0">
        <h3 class="widget-title"><?php echo e(__('Pay now')); ?></h3>
        <div class="row">
            <div class="col-sm-12">
                <?php
                    $gateways = DB::table('payment_settings')->whereStatus(1)->get();
                ?>
                <select class="form-control payment_gateway" required>
                    <option value="" selected disabled><?php echo e(__('Select a payment method')); ?></option>
                    <?php $__currentLoopData = $gateways; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $gateway): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php if(PriceHelper::CheckDigitalPaymentGateway()): ?>
                            <?php if($gateway->unique_keyword != 'cod'): ?>
                                <option value="<?php echo e($gateway->unique_keyword); ?>"><?php echo e($gateway->name); ?></option>
                            <?php endif; ?>
                        <?php else: ?>
                            <option value="<?php echo e($gateway->unique_keyword); ?>"><?php echo e($gateway->name); ?></option>
                        <?php endif; ?>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>

                <?php if($setting->is_privacy_trams == 1): ?>
                    <div class="form-group mt-4">
                        <div class="custom-control d-flex custom-checkbox">
                            <input class="custom-control-input me-2" type="checkbox" id="trams__condition_single"
                                value="">
                            <label class="custom-control-label flex-1" for="trams__condition">This site is protected by
                                reCAPTCHA
                                and the <a href="<?php echo e($setting->policy_link); ?>" target="_blank">Privacy Policy</a> and <a
                                    href="<?php echo e($setting->terms_link); ?>" target="_blank">Terms of Service</a>
                                apply.</label>
                        </div>
                    </div>
                <?php endif; ?>

                <button id="single_checkout_payment" disabled="true"
                    class="btn btn-primary mt-4 single_checkout_payment" type="submit"><span><?php echo app('translator')->get('Pay now'); ?></span></button>
            </div>

        </div>
    </section>

</aside>

<?php $__env->startSection('script'); ?>
    <script>
        // Show the modal on #single_checkout_payment change
        $(document).on("click", "#single_checkout_payment", function() {
            let keyword = $('.payment_gateway').val();
            let modalElement = document.getElementById(keyword);

            if (modalElement) {
                // Open the modal using Bootstrap 5's API
                let modal = new bootstrap.Modal(modalElement);
                modal.show();

                // Get all input fields from the #checkoutBilling form
                let allinput = $("#checkoutBilling input");

                // Clear the modal form before appending new hidden inputs
                $(modalElement).find('form').html(); // Clear modal form content

                // Loop through each input and append a hidden input in the modal form
                allinput.each(function() {
                    // Create a new hidden input field with the same name and value
                    let hiddenInput = $('<input>')
                        .attr('type', 'hidden') // Set the input type to hidden
                        .attr('name', $(this).attr('name')) // Use the same name attribute
                        .val($(this).val()); // Set the value of the hidden input

                    // Append the hidden input to the modal form
                    $(modalElement).find('form').append(hiddenInput);
                });
            }
        });

        // Handle the "Terms and Conditions" checkbox click
        $(document).on("click", "#trams__condition_single", function() {
            if ($("#trams__condition_single").is(':checked')) {
                console.log("check");
                // Enable the dropdown by assigning the ID and removing the disabled attribute
                $('.single_checkout_payment').attr('id', "single_checkout_payment");
                $('.single_checkout_payment').attr('disabled', false);
            } else {
                // Remove the ID and disable the dropdown when unchecked
                $('.single_checkout_payment').removeAttr('id');
                $('.single_checkout_payment').attr('disabled', true);
            }
        });
    </script>
<?php $__env->stopSection(); ?>
<?php /**PATH /home/nirjhor/domains/app.nirjhor.net/public_html/ecommerce/core/resources/views/includes/single_checkout_sidebar.blade.php ENDPATH**/ ?>